"use client"

import { useApplicationWorkflow } from "@/hooks/use-application-workflow";
import { cn } from "@/lib/utils";
import { ComponentWithClassName } from "@/types/utils";
import { TransformedStatewideService } from "../type/transformers";
import { WorkflowButton } from "./workflow.button";

export function WorkflowButtonView({ data, className }: ComponentWithClassName<{ data: NonNullable<TransformedStatewideService> }>) {
  const { setWorkflow } = useApplicationWorkflow()

  return (
    <WorkflowButton
      step="VIEW_SERVICES"
      variant="outline"
      size={"sm"}
      onClick={() => setWorkflow({
        __tag: "VIEW_SERVICES",
        id: data.id,
      })}
      className={cn(
        className
      )}
      aria-label={`Open dialog to view service details for ${data.agencyId} with name ${data.alias}`}
    >
      Details
    </WorkflowButton>
  )
}

